<Query Kind="Statements">
  <Namespace>System.Security.AccessControl</Namespace>
  <Namespace>System.Security.Principal</Namespace>
</Query>

try
{
	File.WriteAllText("sectest.txt", "Plik do testowania bezpieczeństwa.");

	FileSecurity fSecurity = new FileSecurity("sectest.txt", AccessControlSections.Owner |
                                                             AccessControlSections.Group |
                                                             AccessControlSections.Access);

	Console.WriteLine (string.Join (Environment.NewLine, 
        fSecurity.GetAccessRules (true, true, typeof (NTAccount))
        .Cast<AuthorizationRule>()
        .Select (r => r.IdentityReference.Value)));
}
catch (PlatformNotSupportedException ex)
{
	Console.WriteLine ($"Nieobsługiwane: {ex.Message}");
}
finally
{
	File.Delete ("sectest.txt");
}